<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Resturant extends Model 
{

    protected $table = 'resturants';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'phone', 'neighborhood_id', 'password', 'minimum', 'delivery_fees', 'whatsapp');

    public function clients()
    {
        return $this->hasMany('App\Models\Client');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function neighborhood()
    {
        return $this->belongsTo('App\Models\Neighborhood');
    }

    public function classifications()
    {
        return $this->belongsToMany('App\Models\Classification');
    }

    public function categories()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function payments()
    {
        return $this->hasMany('App\Models\Payment');
    }

    public function review()
    {
        return $this->hasMany('App\Models\Review');
    }

    public function notifications()
    {
        return $this->morphMany('App\Models\Notification');
    }

    public function tokens()
    {
        return $this->morphMany('App\Models\Token');
    }

    public function meals()
    {
        return $this->hasMany('App\Models\Meal');
    }

}